/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.controllers.ClientCloneController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.data.SpawnNPCData;
import noppes.npcs.util.Util;

public class GuiNpcMobSpawnerSelector
extends SubGuiInterface
implements IGuiData,
ICustomScrollListener,
ITextfieldListener {
    public int activeTab = 1;
    public int showingClones = 0;
    private GuiCustomScroll scroll;
    public EntityLivingBase selectNpc;
    public SpawnNPCData spawnData;

    public GuiNpcMobSpawnerSelector() {
        this.xSize = 256;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() > 20) {
            this.activeTab = button.getID() - 20;
            this.func_73866_w_();
            return;
        }
        switch (button.getID()) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.scroll.clear();
                this.close();
                break;
            }
            case 3: {
                this.selectNpc = null;
                this.showingClones = 0;
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.selectNpc = null;
                this.showingClones = 1;
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.selectNpc = null;
                this.showingClones = 2;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.selectNpc != null) {
            this.drawNpc((Entity)this.selectNpc, 210, 80, 1.0f, (int)(3L * this.player.field_70170_p.func_82737_E() % 360L), 0, 0);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        Gui.func_73734_a((int)(this.guiLeft + 181), (int)(this.guiTop + 4), (int)(this.guiLeft + 242), (int)(this.guiTop + 90), (int)new Color(-8355712).getRGB());
        Gui.func_73734_a((int)(this.guiLeft + 182), (int)(this.guiTop + 5), (int)(this.guiLeft + 241), (int)(this.guiTop + 89), (int)new Color(-16777216).getRGB());
        GlStateManager.func_179121_F();
    }

    public NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        NBTTagCompound nbtEntity = null;
        if (this.showingClones == 0) {
            nbtEntity = ClientCloneController.Instance.getCloneData((ICommandSender)this.player, sel, this.activeTab);
        } else if (this.showingClones == 1) {
            if (this.spawnData != null) {
                nbtEntity = this.spawnData.compound;
            } else {
                for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                    Entity entity;
                    if (!ent.getName().equals(sel) || !((entity = EntityList.func_188429_b((ResourceLocation)Objects.requireNonNull(ent.getRegistryName()), (World)Minecraft.func_71410_x().field_71441_e)) instanceof EntityLivingBase)) continue;
                    nbtEntity = entity.func_189511_e(new NBTTagCompound());
                    nbtEntity.func_74778_a("id", ent.getRegistryName().toString());
                }
            }
        }
        return nbtEntity;
    }

    public String getSelected() {
        return this.scroll.getSelected();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 188);
        } else {
            this.scroll.clear();
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 26;
        this.addScroll(this.scroll);
        GuiMenuTopButton button = new GuiMenuTopButton(3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        this.addTopButton(button);
        button.active = this.showingClones == 0;
        button = new GuiMenuTopButton(4, button, "spawner.entities");
        this.addTopButton(button);
        button.active = this.showingClones == 1;
        button = new GuiMenuTopButton(5, button, "gui.server");
        this.addTopButton(button);
        boolean bl = button.active = this.showingClones == 2;
        if (this.showingClones == 0 || this.showingClones == 2) {
            int x = this.guiLeft;
            int y = this.guiTop + 4;
            for (int id = 1; id < 10; ++id) {
                GuiMenuSideButton sideButton = new GuiMenuSideButton(20 + id, x, y + (id - 1) * 21, "Tab " + id);
                this.addSideButton(sideButton);
            }
            this.getSideButton(20 + this.activeTab).setActive(true);
            this.showClones();
        } else {
            this.showEntities();
        }
        this.addButton(new GuiNpcButton(0, this.guiLeft + 171, this.guiTop + 170, 80, 20, "gui.done"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 171, this.guiTop + 192, 80, 20, "gui.cancel"));
        if (this.spawnData == null) {
            return;
        }
        this.addLabel(new GuiNpcLabel(5, new TextComponentTranslation("type.count", new Object[0]).func_150254_d() + ":", this.guiLeft + 170, this.guiTop + 153));
        GuiNpcTextField tf = new GuiNpcTextField(2, this, this.guiLeft + 216, this.guiTop + 148, 35, 20, "" + this.spawnData.count);
        tf.setMinMaxDefault(0L, 7L, this.spawnData.count);
        this.addTextField(tf);
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 200 || i == 208 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.resetEntity();
        }
    }

    private void resetEntity() {
        String sel = this.scroll.getSelected();
        if (this.showingClones == 0) {
            NBTTagCompound npcNbt = ClientCloneController.Instance.getCloneData((ICommandSender)this.player, sel, this.activeTab);
            if (npcNbt == null) {
                return;
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)npcNbt, (World)Minecraft.func_71410_x().field_71441_e);
            if (entity instanceof EntityLivingBase) {
                if (this.spawnData != null) {
                    this.spawnData.typeClones = 0;
                    this.spawnData.compound = npcNbt;
                }
                this.selectNpc = (EntityLivingBase)entity;
            }
        } else if (this.showingClones == 1) {
            for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
                if (!ent.getName().equals(sel)) continue;
                Entity entity = EntityList.func_188429_b((ResourceLocation)Objects.requireNonNull(ent.getRegistryName()), (World)Minecraft.func_71410_x().field_71441_e);
                if (entity instanceof EntityLivingBase) {
                    this.selectNpc = (EntityLivingBase)entity;
                    if (this.spawnData != null) {
                        this.spawnData.typeClones = 1;
                        this.spawnData.compound = entity.func_189511_e(new NBTTagCompound());
                        this.spawnData.compound.func_74778_a("id", ent.getRegistryName().toString());
                    }
                }
                return;
            }
        } else {
            if (this.spawnData != null) {
                this.spawnData.typeClones = 2;
                this.spawnData.compound = new NBTTagCompound();
                this.spawnData.compound.func_74778_a("Name", sel);
            }
            Client.sendData(EnumPacketServer.GetClone, false, sel, this.activeTab);
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        String sel = scroll.getSelected();
        if (sel == null) {
            return;
        }
        this.resetEntity();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        this.close();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_150297_b("NPCData", 10)) {
            this.selectNpc = (EntityNPCInterface)EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("NPCData"), (World)this.player.field_70170_p);
            return;
        }
        NBTTagList nbtList = compound.func_150295_c("List", 8);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            list.add(nbtList.func_150307_f(i));
        }
        this.scroll.setList(list);
        if (this.spawnData != null) {
            this.scroll.setSelected(Util.instance.deleteColor(this.spawnData.getTitle()));
            if (this.selectNpc == null) {
                String name = new TextComponentTranslation("type.empty", new Object[0]).func_150254_d();
                if (this.spawnData.compound != null) {
                    if (this.spawnData.compound.func_74764_b("ClonedName")) {
                        name = new TextComponentTranslation(this.spawnData.compound.func_74779_i("ClonedName"), new Object[0]).func_150254_d();
                    } else if (this.spawnData.compound.func_74764_b("Name")) {
                        name = new TextComponentTranslation(this.spawnData.compound.func_74779_i("Name"), new Object[0]).func_150254_d();
                    }
                }
                Client.sendData(EnumPacketServer.GetClone, false, name, this.activeTab);
            }
        }
    }

    private void showClones() {
        if (this.showingClones == 2) {
            Client.sendData(EnumPacketServer.CloneList, this.activeTab);
            return;
        }
        this.scroll.setList(new ArrayList<String>(ClientCloneController.Instance.getClones(this.activeTab)));
    }

    private void showEntities() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (Objects.requireNonNull(ent.getRegistryName()).func_110624_b().equals("customnpcs")) continue;
            Class c = ent.getEntityClass();
            String name = ent.getName();
            try {
                Entity entity;
                if (classes.contains(c) || !EntityLiving.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || !((entity = EntityList.func_188429_b((ResourceLocation)ent.getRegistryName(), (World)Minecraft.func_71410_x().field_71441_e)) instanceof EntityMob)) continue;
                list.add(name);
                classes.add(c);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        this.scroll.setList(list);
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.spawnData == null || textField.getID() != 2) {
            return;
        }
        this.spawnData.count = textField.getInteger();
    }
}

